## FUNCTION TO LABEL COEFFICIENTS WITH SIGNIFICANCE STARS

# x is the summary table of a lm or lm_robust regression
# v is the variable name
# digits is the number of significant digits
stars<-function(x,v,digits) {
  xcoef<-signif(x$coefficients[v,1],digits)
  pval<-x$coefficients[v,4]
  out<-""
  if (pval<=0.1&pval>0.05) {out<-"$^{*}$"}
  if (pval<=0.05&pval>0.01) {out<-"$^{**}$"}
  if (pval<=0.01&pval>0.001) {out<-"$^{***}$"}
  if (pval<=0.001) {out<-"$^{***}$"}
  return(paste(xcoef,out,sep=""))
}
